/*
 * AdaptivityMap.hpp
 *
 *  Created on: Oct 20, 2011
 *      Author: heber
 */

#ifndef ADAPTIVITYMAP_HPP_
#define ADAPTIVITYMAP_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iosfwd>
#include <string>

#include <map>

#include "Fragmentation/KeySet.hpp"

class AtomMask_t;
class molecule;

class AdaptivityMap : public std::map<int, KeySet>
{
public:
  AdaptivityMap();
  ~AdaptivityMap();

  void InsertIntoAdaptiveCriteriaList(int FragOrder, int No, double Value);
  void ScanAdaptiveFileIntoMap(const std::string &path);
  void ReMapAdaptiveCriteriaListToValue(molecule *mol);
  int CountLinesinFile(std::ifstream &InputFile) const;
  bool MarkUpdateCandidates(AtomMask_t &AtomMask, int Order, molecule *mol) const ;

  bool IsAdaptiveCriteriaListEmpty() const;

private:
  typedef std::map<double, std::pair<int,int> > AdaptiveCriteriaValueMap;
  typedef std::map<int, std::pair<double,int> > AdaptiveCriteriaIndexMap;

  AdaptiveCriteriaIndexMap *AdaptiveCriteriaList;
  AdaptiveCriteriaValueMap *FinalRootCandidates;
};


#endif /* ADAPTIVITYMAP_HPP_ */
