/*
 * UIFactory.cpp
 *
 *  Created on: Jan 5, 2010
 *      Author: crueger
 */

#include "Helpers/MemDebug.hpp"

#include <cassert>
#include "Patterns/Singleton_impl.hpp"
#include "UIFactory.hpp"

// all factories that can be used:
#include "TextUI/TextUIFactory.hpp"
#include "CommandLineUI/CommandLineUIFactory.hpp"

UIFactory::UIFactory()
{
  // TODO Auto-generated constructor stub

}

UIFactory::~UIFactory()
{
  // TODO Auto-generated destructor stub
}

void UIFactory::makeUserInterface(InterfaceTypes type) {
  switch(type) {
    case Text :
      setInstance(new TextUIFactory());
      break;
    case CommandLine:
      setInstance(new CommandLineUIFactory());
      break;

    default:
      assert(0 && "No such Factory in stock");
      break;
  }
}

CONSTRUCT_SINGLETON(UIFactory)
