/*
 * HelpAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include "Actions/CmdAction/HelpAction.hpp"
#include "CommandLineParser.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "UIElements/UIFactory.hpp"
#include "UIElements/Dialog.hpp"

const char CommandLineHelpAction::NAME[] = "help";

CommandLineHelpAction::CommandLineHelpAction() :
  Action(NAME)
{}

CommandLineHelpAction::~CommandLineHelpAction()
{}

Action::state_ptr CommandLineHelpAction::performCall() {
  ostringstream usage;
  Dialog *dialog = UIFactory::getInstance().makeDialog();

  usage << CommandLineParser::getInstance().visible << endl;
  dialog->queryEmpty(NAME, usage.str());

  if(dialog->display()) {
    delete dialog;
    return Action::success;
  } else {
    delete dialog;
    return Action::failure;
  }
}

Action::state_ptr CommandLineHelpAction::performUndo(Action::state_ptr _state) {
//  ParserLoadXyzState *state = assert_cast<ParserLoadXyzState*>(_state.get());

  return Action::failure;
//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);
//
//  return Action::state_ptr(new ParserLoadXyzState(state->mol,newName));
}

Action::state_ptr CommandLineHelpAction::performRedo(Action::state_ptr _state){
  return Action::failure;
}

bool CommandLineHelpAction::canUndo() {
  return false;
}

bool CommandLineHelpAction::shouldUndo() {
  return false;
}

const string CommandLineHelpAction::getName() {
  return NAME;
}
