/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2014 Frederik Heber. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * StructuralOptimizationAction.cpp
 *
 *  Created on: Aug 02, 2014
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Chronos.hpp"

#include "Actions/FragmentationAction/AnalyseFragmentationResultsAction.hpp"
#include "Actions/FragmentationAction/FragmentationAutomationAction.hpp"
#include "Actions/FragmentationAction/StructuralOptimizationAction.hpp"
#include "Actions/MoleculeAction/ForceAnnealingAction.hpp"
#include "Actions/ActionQueue.hpp"
#include "Actions/ActionSequence.hpp"

#include "Descriptors/AtomDescriptor.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "StructuralOptimizationAction.def"
#include "MakroAction_impl_pre.hpp"
/** =========== define the function ====================== */

// static instances
ActionSequence FragmentationStructuralOptimizationAction::actions;
bool FragmentationStructuralOptimizationAction::isPrepared = false;

void FragmentationStructuralOptimizationAction::prepare(ActionRegistry &AR)
{
  // perform a verlet-integration first, if there are already forces or velocities
  // present. If not, we still copy the position cleanly into a new step where then
  // forces are set according to summed fragmentary contributions. This is much cleaner.
  actions.addAction(AR.getActionByName(std::string("fragment-molecule")));
  actions.addAction(AR.getActionByName(std::string("fragment-automation")));
  actions.addAction(AR.getActionByName(std::string("analyse-fragment-results")));
  actions.addAction(AR.getActionByName(std::string("force-annealing")));
  actions.addAction(AR.getActionByName(std::string("output")));
  actions.addAction(AR.getActionByName(std::string("clear-fragment-results")));
  isPrepared = true;
}

void FragmentationStructuralOptimizationAction::unprepare(ActionRegistry &AR)
{
  // empty sequence
  while (actions.removeLastAction() != NULL);
  isPrepared = false;
}

ActionState::ptr FragmentationStructuralOptimizationAction::performCall(){

  // set number of steps
  setLoop(params.steps.get());
  // remove output from sequence if not desired.
  if (!params.DoOutput.get()) {
#ifndef NDEBUG
    bool status =
#endif
        removeAction(std::string("output"));
    ASSERT( status,
        "FragmentationStructuralOptimizationAction::performCall() - output not found in ActionSequence.");
  }
  // and call
  ActionState::ptr state(MakroAction::performCall());

  return state;
}

ActionState::ptr FragmentationStructuralOptimizationAction::performUndo(ActionState::ptr _state) {
  ActionState::ptr state(MakroAction::performUndo(_state));

  return state;
}

ActionState::ptr FragmentationStructuralOptimizationAction::performRedo(ActionState::ptr _state){
  ActionState::ptr state(MakroAction::performRedo(_state));

  return state;
}

bool FragmentationStructuralOptimizationAction::canUndo(){
  return true;
}

bool FragmentationStructuralOptimizationAction::shouldUndo(){
  return true;
}
