/*
 * RangeValidator.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef RANGEVALIDATOR_HPP_
#define RANGEVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Validator.hpp"
#include "CodePatterns/Range.hpp"

/** A validator with an interval of valid values.
 *
 */
template <class T>
class RangeValidator : public Validator<T>
{
public:
  RangeValidator(const range<T> &_ValidRange) : ValidRange(_ValidRange) {};
  RangeValidator(const T&min, const T&max) : ValidRange(min,max) {};
  virtual ~RangeValidator() {};

  bool isValid(const T & _value) const;

  Validator<T>* clone() const;

  // comparator
  bool operator==(const Validator<T> &_instance) const;

  // getter/setter for valid ranges
  void setValidRange(const range<T> &_range);
  const range<T> & getValidRange() const {  return ValidRange;  };

private:
  //!> valid range of values
  range<T> ValidRange;
};


#include "RangeValidator_impl.hpp"


#endif /* RANGEVALIDATOR_HPP_ */
