/*
 * QtSelectionChangedAgent.hpp
 *
 *  Created on: Jul 17, 2015
 *      Author: heber
 */

#ifndef QTSELECTIONCHANGEDAGENT_HPP_
#define QTSELECTIONCHANGEDAGENT_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/QObject>

#include <vector>

#include <boost/thread/recursive_mutex.hpp>

#include "CodePatterns/Observer/Observable.hpp"

#include "types.hpp"

class QtSelectionChangedAgent :
  public QObject,
  public Observable
{
  Q_OBJECT

public:
  QtSelectionChangedAgent(QObject *_parent);
  ~QtSelectionChangedAgent();

signals:

  void atomSelected(const moleculeId_t, const atomId_t);
  void atomUnselected(const moleculeId_t, const atomId_t);
  void moleculeSelected(const moleculeId_t);
  void moleculeUnselected(const moleculeId_t);

protected:
  virtual void update(Observable *publisher);
  virtual void recieveNotification(Observable *publisher, Notification_ptr notification);
  virtual void subjectKilled(Observable *publisher);

private:
  typedef std::vector<atomId_t> selectedAtoms_t;
  selectedAtoms_t selectedAtoms;
  typedef std::vector<moleculeId_t> selectedMolecules_t;
  selectedMolecules_t selectedMolecules;

  boost::recursive_mutex mutex;
};


#endif /* QTSELECTIONCHANGEDAGENT_HPP_ */
