/*
 * fast_functions.hpp
 *
 *  Created on: Apr 1, 2010
 *      Author: crueger
 */

#ifndef FAST_FUNCTIONS_HPP_
#define FAST_FUNCTIONS_HPP_

#include "Helpers/defs.hpp"

/**
 * !@file
 * This file contains several functions that need to be very fast and which are inlined for this
 * reason.
 *
 * Warning: do not forget inline keyword for functions in this file to avoid multiple definitions!
 */

/********************************* Functions ************************************************/

/** hard-coded determinant of a 3x3 matrix.
 * \param a[9] matrix
 * \return \f$det(a)\f$
 */
inline double RDET3(const double a[NDIM*NDIM])
{
  return ((a)[0]*(a)[4]*(a)[8] + (a)[3]*(a)[7]*(a)[2] + (a)[6]*(a)[1]*(a)[5] - (a)[2]*(a)[4]*(a)[6] - (a)[5]*(a)[7]*(a)[0] - (a)[8]*(a)[1]*(a)[3]);
};

/** hard-coded determinant of a 2x2 matrix.
 * \param a[4] matrix
 * \return \f$det(a)\f$
 */
inline double RDET2(const double a[4])
{
  return ((a[0])*(a[3])-(a[1])*(a[2]));
};

/** hard-coded determinant of a 2x2 matrix.
 * \param a0 (0,0) entry of matrix
 * \param a1 (0,1) entry of matrix
 * \param a2 (1,0) entry of matrix
 * \param a3 (1,1) entry of matrix
 * \return \f$det(a)\f$
 */
inline double RDET2(const double a0, const double a1, const double a2, const double a3)
{
  return ((a0)*(a3)-(a1)*(a2));
};

/** Returns the power of \a n with respect to \a base.
 * \param base basis
 * \param n power
 * \return \f$base^n\f$
 */
inline int pot(int base, int n)
{
  int res = 1;
  int j;
  for (j=n;j--;)
    res *= base;
  return res;
};

/*************************** Templatized functions ************************************/

/** Flips two values.
 * \param x first value
 * \param y second value
 */
template <typename T>
inline void flip(T &x, T &y)
{
  T tmp;
  tmp = x;
  x = y;
  y = tmp;
};

#endif /* FAST_FUNCTIONS_HPP_ */
