/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * LinearInterpolationofTrajectoriesAction.cpp
 *
 *  Created on: May 10, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "atom.hpp"
#include "Helpers/defs.hpp"
#include "Helpers/Log.hpp"
#include "molecule.hpp"
#include "Helpers/Verbose.hpp"
#include "World.hpp"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

#include "Actions/MoleculeAction/LinearInterpolationofTrajectoriesAction.hpp"

// and construct the stuff
#include "LinearInterpolationofTrajectoriesAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performCall() {
  molecule *mol = NULL;

  // obtain information
  getParametersfromValueStorage();

  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    mol = iter->second;
    DoLog(1) && (Log() << Verbose(1) << "Linear interpolation between configuration " << params.start << " and " << params.end << "." << endl);
    if (params.IdMapping)
      DoLog(1) && (Log() << Verbose(1) << "Using Identity for the permutation map." << endl);
    if (!mol->LinearInterpolationBetweenConfiguration(params.start, params.end, params.filename.branch_path().string(), *(World::getInstance().getConfig()), params.IdMapping))
      DoLog(2) && (Log() << Verbose(2) << "Could not store " << params.filename << " files." << endl);
    else
      DoLog(2) && (Log() << Verbose(2) << "Steps created and " << params.filename << " files stored." << endl);
  }
  return Action::success;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performUndo(Action::state_ptr _state) {
//  MoleculeLinearInterpolationofTrajectoriesState *state = assert_cast<MoleculeLinearInterpolationofTrajectoriesState*>(_state.get());

//  string newName = state->mol->getName();
//  state->mol->setName(state->lastName);

  return Action::failure;
}

Action::state_ptr MoleculeLinearInterpolationofTrajectoriesAction::performRedo(Action::state_ptr _state){
  // Undo and redo have to do the same for this action
  return performUndo(_state);
}

bool MoleculeLinearInterpolationofTrajectoriesAction::canUndo() {
  return false;
}

bool MoleculeLinearInterpolationofTrajectoriesAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
