/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MolecularVolumeAction.cpp
 *
 *  Created on: May 12, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Helpers/MemDebug.hpp"

#include "boundary.hpp"
#include "config.hpp"
#include "molecule.hpp"
#include "linkedcell.hpp"
#include "Helpers/Log.hpp"
#include "Helpers/Verbose.hpp"
#include "tesselation.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

using namespace std;

#include "Actions/AnalysisAction/MolecularVolumeAction.hpp"

// and construct the stuff
#include "MolecularVolumeAction.def"
#include "Action_impl_pre.hpp"

/** =========== define the function ====================== */
Action::state_ptr AnalysisMolecularVolumeAction::performCall() {
  // obtain information
  getParametersfromValueStorage();

  // execute action
  for (World::MoleculeSelectionIterator iter = World::getInstance().beginMoleculeSelection(); iter != World::getInstance().endMoleculeSelection(); ++iter) {
    molecule *mol = iter->second;
    class Tesselation *TesselStruct = NULL;
    const LinkedCell *LCList = NULL;
    DoLog(0) && (Log() << Verbose(0) << "Evaluating volume of the convex envelope.");
    LCList = new LinkedCell(*mol, 10.);
    config * const configuration = World::getInstance().getConfig();
    //Boundaries *BoundaryPoints = NULL;
    //FindConvexBorder(mol, BoundaryPoints, TesselStruct, LCList, argv[argptr]);
    FindNonConvexBorder(mol, TesselStruct, LCList, 5., NULL);
    //RemoveAllBoundaryPoints(TesselStruct, mol, argv[argptr]);
    double volumedifference = ConvexizeNonconvexEnvelope(TesselStruct, mol, NULL);
    double clustervolume = VolumeOfConvexEnvelope(TesselStruct, configuration);
    DoLog(0) && (Log() << Verbose(0) << "The tesselated volume area is " << clustervolume << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    DoLog(0) && (Log() << Verbose(0) << "The non-convex tesselated volume area is " << clustervolume-volumedifference << " " << (configuration->GetIsAngstroem() ? "angstrom" : "atomiclength") << "^3." << endl);
    delete(TesselStruct);
    delete(LCList);
  }
  return Action::success;
}

Action::state_ptr AnalysisMolecularVolumeAction::performUndo(Action::state_ptr _state) {
  return Action::success;
}

Action::state_ptr AnalysisMolecularVolumeAction::performRedo(Action::state_ptr _state){
  return Action::success;
}

bool AnalysisMolecularVolumeAction::canUndo() {
  return true;
}

bool AnalysisMolecularVolumeAction::shouldUndo() {
  return true;
}
/** =========== end of function ====================== */
