/*
 * VMGDataMap.hpp
 *
 *  Created on: Aug 8, 2012
 *      Author: heber
 */

#ifndef VMGDATAMAP_HPP_
#define VMGDATAMAP_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/fusion/container/map.hpp>
#include <boost/mpl/list.hpp>

#include "Fragmentation/Summation/Containers/VMGDataFused.hpp"

class SamplingGrid;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in VMGData and their type.
 *
 * This lets us resolves any ambiguitites of types in VMGData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<VMGDataFused::sampled_potential, SamplingGrid >,
    boost::fusion::pair<VMGDataFused::both_sampled_potential, SamplingGrid >,
    boost::fusion::pair<VMGDataFused::nuclei_long, double >,
    boost::fusion::pair<VMGDataFused::electron_long, double >
> VMGDataMap_t;

typedef boost::mpl::list<
    VMGDataFused::sampled_potential,
    VMGDataFused::both_sampled_potential,
    VMGDataFused::nuclei_long,
    VMGDataFused::electron_long
> VMGDataVector_t;

/** This boost::fusion map defines key-value or rather key-type pairs with
 * which we associate all sampled_grid data members in VMGData and their type.
 *
 * This lets us resolves any ambiguitites of types in VMGData, e.g.
 * to know vector<double> is forces or energy_eigenvalues.
 *
 */
typedef boost::fusion::map<
    boost::fusion::pair<VMGDataFused::electron_longrange, double >,
    boost::fusion::pair<VMGDataFused::electron_shortrange, double >,
    boost::fusion::pair<VMGDataFused::mixed_longrange, double >,
    boost::fusion::pair<VMGDataFused::mixed_shortrange, double >,
    boost::fusion::pair<VMGDataFused::nuclei_longrange, double >,
    boost::fusion::pair<VMGDataFused::nuclei_shortrange, double >,
    boost::fusion::pair<VMGDataFused::total_longrange, double >,
    boost::fusion::pair<VMGDataFused::total_shortrange, double >
> VMGDataLongRangeMap_t;

typedef boost::mpl::list<
    VMGDataFused::electron_longrange,
    VMGDataFused::electron_shortrange,
    VMGDataFused::mixed_longrange,
    VMGDataFused::mixed_shortrange,
    VMGDataFused::nuclei_longrange,
    VMGDataFused::nuclei_shortrange,
    VMGDataFused::total_longrange,
    VMGDataFused::total_shortrange
> VMGDataLongRangeVector_t;


#endif /* VMGDATAMAP_HPP_ */
