/*
 * VMGData.hpp
 *
 *  Created on: Aug 6, 2012
 *      Author: heber
 */

#ifndef VMGDATA_HPP_
#define VMGDATA_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <boost/serialization/access.hpp>
#include <boost/serialization/vector.hpp>

#include <iosfwd>
#include <vector>

#include "Fragmentation/Summation/SetValues/SamplingGrid.hpp"

/** This struct contains all returned data from an VMGJob
 *
 */
struct VMGData
{
  /** Constructor for class VMGData.
   *
   * \param _props properties of sampled potential
   */
  VMGData(const SamplingGridProperties &_props);

  /** Default constructor for class VMGData.
   *
   */
  VMGData();

  //!> sampled potential on the grid as output
  SamplingGrid sampled_potential;
  //!> sampled potential on the grid as output
  SamplingGrid both_sampled_potential;
  //!> nuclei long-range contribution to energy
  double nuclei_long;
  //!> electron long-range contribution to energy
  double electron_long;

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & sampled_potential;
    if (version > 1)
      ar & both_sampled_potential;
    if (version > 0)
      ar & nuclei_long;
    ar & electron_long;
  }
};

BOOST_CLASS_VERSION(VMGData, 2)

std::ostream & operator<<(std::ostream &ost, const VMGData &data);


#endif /* VMGDATA_HPP_ */
