/*
 * ObserverTest.hpp
 *
 *  Created on: Jan 19, 2010
 *      Author: crueger
 */

#ifndef OBSERVERTEST_HPP_
#define OBSERVERTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/extensions/HelperMacros.h>

// forward declaration for test stubs
class UpdateCountObserver;
class NotificationObserver;
class SimpleObservable;
class CallObservable;
class SuperObservable;
class ObservableSet;
class ObservableMap;
class BlockObservable;
class NotificationObservable;

class ObserverTest :  public CppUnit::TestFixture
{
  CPPUNIT_TEST_SUITE( ObserverTest ) ;
  CPPUNIT_TEST ( doesUpdateTest );
  CPPUNIT_TEST ( doesBlockUpdateTest );
  CPPUNIT_TEST ( doesSubObservableTest );
  CPPUNIT_TEST ( outsideLockTest );
  CPPUNIT_TEST ( doesNotifyTest );
  CPPUNIT_TEST ( doesReportTest );
  CPPUNIT_TEST ( iteratorTest );
  CPPUNIT_TEST ( CircleDetectionTest );
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp();
  void tearDown();

  void doesUpdateTest();
  void doesBlockUpdateTest();
  void doesSubObservableTest();
  void outsideLockTest();
  void doesNotifyTest();
  void doesReportTest();
  void iteratorTest();
  void CircleDetectionTest();

private:
  UpdateCountObserver *observer1;
  UpdateCountObserver *observer2;
  UpdateCountObserver *observer3;
  UpdateCountObserver *observer4;

  NotificationObserver *notificationObserver1;
  NotificationObserver *notificationObserver2;

  SimpleObservable *simpleObservable1;
  SimpleObservable *simpleObservable2;
  CallObservable *callObservable;
  BlockObservable *blockObservable;
  SuperObservable *superObservable;
  NotificationObservable *notificationObservable;
  ObservableSet *obsset;
  ObservableMap *obsmap;

};

#endif /* OBSERVERTEST_HPP_ */
