/*
 * GLMoleculeObject_molecule.hpp
 *
 *  Created on: Mar 30, 2012
 *      Author: ankele
 */

#ifndef GLMOLECULEOBJECT_MOLECULE_HPP_
#define GLMOLECULEOBJECT_MOLECULE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include <Qt3D/qgeometrydata.h>

#include "UIElements/Qt4/InstanceBoard/QtObservedMolecule.hpp"

#include <map>

#include <boost/function.hpp>

#include "CodePatterns/Cacheable.hpp"
#include "CodePatterns/Observer/Observable.hpp"

#include "GLMoleculeObject_bond.hpp"

#include "types.hpp"

class atom;
class bond;
class molecule;
class GLMoleculeObject_atom;
class GLWorldScene;
class QtObservedInstanceBoard;

class GLMoleculeObject_molecule : public GLMoleculeObject
{
  Q_OBJECT
public:
  GLMoleculeObject_molecule(
      QObject *parent,
      QtObservedInstanceBoard &_board,
      QtObservedMolecule::ptr &_ObservedMolecule);
  GLMoleculeObject_molecule(
      QGLSceneNode *mesh[],
      QObject *parent,
      QtObservedInstanceBoard &_board,
      QtObservedMolecule::ptr &_ObservedMolecule);
  virtual ~GLMoleculeObject_molecule();

  void initialize(QGLView *view, QGLPainter *painter);
  void draw(QGLPainter *painter, const QVector4D &cameraPlane);

  typedef std::pair< atomId_t, atomId_t> BondIds;
  friend std::ostream &operator<<(std::ostream &ost, const BondIds &t);

  static BondIds getBondIds(
      const bond::ptr _bond,
      const enum GLMoleculeObject_bond::SideOfBond side);

signals:
  void changed();
  void changeOccured();
  void hoverChanged(const atomId_t);
  void hoverChanged(const moleculeId_t, int);
  void indexChanged(GLMoleculeObject_molecule *, const moleculeId_t, const moleculeId_t);
  void atomClicked(atomId_t);
  void moleculeClicked(moleculeId_t);
  void moleculeEmptied(QtObservedMolecule::ptr);
  void IsSelectedChanged();

private slots:
  //!> grant GLWorldScene access to private slots
  friend class GLWorldScene;

  void wasClicked();
  void atomInserted(QtObservedAtom::ptr _atom);
  void atomRemoved(const atomId_t _id);
  void bondInserted(const atomId_t, const atomId_t, const GLMoleculeObject_bond::SideOfBond side);
  void bondRemoved(const atomId_t leftnr, const atomId_t rightnr);
  void hoverChangedSignalled(GLMoleculeObject *ob);
  void changeAtomId(GLMoleculeObject_atom *, const atomId_t, const atomId_t);

  void setVisible(bool value);

  void resetTesselationHull();
  void resetBoundingBox();
  void resetIndex(const moleculeId_t, const moleculeId_t);
  void resetSelected();

private:
  void addAtomBonds(
      const bond::ptr &_bond,
      const GLMoleculeObject_bond::SideOfBond _side
      );

  void init(const moleculeId_t _molid);

  //!> typedef for the internal set of atoms
  typedef std::set<atomId_t> atoms_t;

  /** Getter to contained atoms contained in \a ObservedValues.
   *
   * \return molecule's contained atoms
   */
  atoms_t getPresentAtoms() const;

private:

  //!> the Observable we are signed on, also indicates whether we are sign on (not NULL)
  const Observable * owner;

  QGeometryData updateTesselationHull() const;

  //!> list of channels when tesselation hull needs to update
  static const Observable::channels_t HullChannels;

  //!> internal variable for caching molecule ref in cstor
  const molecule * const molref;

  //!> contains current version of the tesselation hull on request
  QGeometryData TesselationHull;

  //!> contains the set of atoms displayed
  atoms_t DisplayedAtoms;

  typedef std::map< atomId_t, GLMoleculeObject_atom* > AtomNodeMap;
  typedef std::map< BondIds , GLMoleculeObject_bond* > BondNodeMap;
  AtomNodeMap AtomsinSceneMap;
  BondNodeMap BondsinSceneMap;

  atomId_t hoverAtomId;

  QtObservedInstanceBoard &board;

  QtObservedMolecule::ptr ObservedMolecule;
};

std::ostream &operator<<(std::ostream &ost, const GLMoleculeObject_molecule::BondIds &t);


#endif /* GLMOLECULEOBJECT_MOLECULE_HPP_ */
