/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * VectorSetUnitTest.cpp
 *
 *  Created on: Jan 06, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "VectorSetUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include <iostream>

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( VectorSetTest );


void VectorSetTest::setUp()
{
  list.push_back(Vector(0.,0.,0.));
  list.push_back(Vector(1.,0.,0.));
  list.push_back(Vector(0.,1.,0.));
  list.push_back(Vector(0.,1.,1.));
  list.push_back(Vector(2.,1.,0.));
  list.push_back(Vector(1.,2.,3.));

  CPPUNIT_ASSERT_EQUAL( (size_t)6, list.size() );
}


void VectorSetTest::tearDown()
{
  list.clear();
}

/** UnitTest for translate()
 */
void VectorSetTest::translateTest()
{
  VECTORSET(std::vector) worklist(list);
  Vector translater(1.,0.,0.);
  worklist.translate(translater);
  VECTORSET(std::vector)::const_iterator iter = list.begin();
  VECTORSET(std::vector)::const_iterator workiter = worklist.begin();
  for (;(iter != list.end()) && (workiter != worklist.end()); ++iter, ++workiter)
    CPPUNIT_ASSERT( ((*iter)+(translater)) == (*workiter) );
}

/** UnitTest for minDistance()
 */
void VectorSetTest::minDistanceTest()
{
  {
    VECTORSET(std::vector) somelist;
    for (double x=1.;x<6.;++x)
      somelist.push_back(Vector(x,0.,0.));
    Vector center(0.,0.,0.);
    Vector mindist = somelist.minDistance(center);
    CPPUNIT_ASSERT_EQUAL (Vector(1., 0., 0.), mindist);
  }
  {
    Vector center(5.,0.,0.);
    Vector mindist = list.minDistance(center);
    CPPUNIT_ASSERT_EQUAL (Vector(2., 1., 0.)-center, mindist);
  }
  {
    for (VECTORSET(std::vector)::const_iterator iter = list.begin();
        iter != list.end(); ++iter) {
      Vector mindist = list.minDistance(*iter);
      CPPUNIT_ASSERT_EQUAL( Vector(0.,0.,0.), mindist );
    }
  }
}

/** UnitTest for minDistance()
 */
void VectorSetTest::minDistSquaredTest()
{
  {
    Vector center(5.,0.,0.);
    double mindist = list.minDistSquared(center);
    double check = Vector(2., 1., 0.).DistanceSquared(center);
    CPPUNIT_ASSERT_EQUAL( check, mindist );
  }
  {
    for (VECTORSET(std::vector)::const_iterator iter = list.begin();
        iter != list.end(); ++iter) {
      double mindist = list.minDistSquared(*iter);
      CPPUNIT_ASSERT_EQUAL( 0., mindist );
    }
  }
}
