/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * DiscreteValueUnitTest.cpp
 *
 *  Created on: Sep 28, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "DiscreteValueUnitTest.hpp"

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include "Parser/DiscreteValue.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

using namespace std;

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( DiscreteValueTest );


void DiscreteValueTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  for (int i=1; i<=3;++i) {
    ValidValues.push_back(i);
  }
}

void DiscreteValueTest::tearDown()
{
  ValidValues.clear();
}

/************************************ tests ***********************************/

/** Unit test for findIndexOfValue.
 *
 */
void DiscreteValueTest::findIndexOfValueTest()
{
  // create instance
  DiscreteValue<int> test(ValidValues);

  // check valid values indices
  CPPUNIT_ASSERT_EQUAL((size_t)0, test.findIndexOfValue(1));
  CPPUNIT_ASSERT_EQUAL((size_t)1, test.findIndexOfValue(2));
  CPPUNIT_ASSERT_EQUAL((size_t)2, test.findIndexOfValue(3));

  // check invalid ones
  for (int i=-10; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL((size_t)-1, test.findIndexOfValue(i));
  for (int i=4; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL((size_t)-1, test.findIndexOfValue(i));
}

/** Unit test for isValid.
 *
 */
void DiscreteValueTest::isValidTest()
{
  // create instance
  DiscreteValue<int> test(ValidValues);

  // checking valid values
  for (int i=1; i<=3;++i)
    CPPUNIT_ASSERT_EQUAL(true, test.isValid(i));

  // checking invalid values
  for (int i=-10; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
  for (int i=4; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
}

/** Unit test for appendValidValue.
 *
 */
void DiscreteValueTest::appendValidValueTest()
{
  // create instance
  DiscreteValue<int> test(ValidValues);

  // adding values 4,5,6
  for (int i=4; i<=6;++i) {
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
    test.appendValidValue(i);
    CPPUNIT_ASSERT_EQUAL(true, test.isValid(i));
  }

  // adding same value, throws assertion
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  for (int i=1; i<=6;++i)
    CPPUNIT_ASSERT_THROW(test.appendValidValue(i), Assert::AssertionFailure);
#endif

  // checking valid values
  for (int i=1; i<=6;++i)
    CPPUNIT_ASSERT_EQUAL(true, test.isValid(i));

  // checking invalid values
  for (int i=-10; i<=0;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));

  // checking invalid values
  for (int i=7; i<=10;++i)
    CPPUNIT_ASSERT_EQUAL(false, test.isValid(i));
}

/** Unit test for setters and getters.
 *
 */
void DiscreteValueTest::settergetterTest()
{
  // create instance
  DiscreteValue<int> test(ValidValues);

  // unset calling of get, throws
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.get(), Assert::AssertionFailure);
#endif

  // setting invalid, throws
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.set(4), Assert::AssertionFailure);
#endif
#ifndef NDEBUG
  std::cout << "The following Assert failures are intended and do not indicate a failure of the test." << std::endl;
  CPPUNIT_ASSERT_THROW(test.set(0), Assert::AssertionFailure);
#endif

  // checking all valid ones
  for (int i=1; i<=3;++i) {
    test.set(i);
    CPPUNIT_ASSERT_EQUAL(i, test.get());
  }
}



