/*
 * DiscreteValue.hpp
 *
 *  Created on: Sep 28, 2011
 *      Author: heber
 */

#ifndef DISCRETEVALUE_HPP_
#define DISCRETEVALUE_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>
#include <vector>

/** This class represents a discrete value.
 *
 */
template <class T>
class DiscreteValue
{
  //!> unit test needs to have access to internal values
  friend class DiscreteValueTest;
public:
  DiscreteValue();
  DiscreteValue(const std::vector<T> &_ValidValues);
  virtual ~DiscreteValue();

  // functions for ValueInterface
  bool isValid(const T &_value) const;

  // init functions
  void appendValidValue(const T &_value);
  const std::vector<T> &getValidValues() const;

  // getter and setter
  void set(const T &_value);

  const T & get() const;

  const size_t getIndexOfValue() const { return value; }

private:
  const size_t findIndexOfValue(const T &_value) const;

  //!> Typedef for the vector of valid values.
  typedef std::vector<T> ValidRange;

  //!> whether a value has been set or not
  bool ValueSet;

  //!> we only store the index within the \a ValidValues for the value
  size_t value;
  //!> list of valid values
  std::vector<T> ValidValues;
};

#include "DiscreteValue_impl.hpp"

#endif /* DISCRETEVALUE_HPP_ */
