/*
 * ShapeOps.cpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#include "Shapes/ShapeOps.hpp"
#include "Shapes/ShapeOps_impl.hpp"

Resize_impl::Resize_impl(const Shape::impl_ptr &_arg,double _size) :
  arg(_arg), size(_size)
{}

Resize_impl::~Resize_impl(){}

bool Resize_impl::isInside(const Vector& point){
  return arg->isInside((1/size) * point);
}

Shape resize(const Shape &arg,double size){
  Shape::impl_ptr impl = Shape::impl_ptr(new Resize_impl(getShapeImpl(arg),size));
  return Shape(impl);
}

Translate_impl::Translate_impl(const Shape::impl_ptr &_arg, const Vector &_offset) :
  arg(_arg),offset(_offset)
{}

Translate_impl::~Translate_impl(){}

bool Translate_impl::isInside(const Vector& point){
  return arg->isInside(point-offset);
}

Shape translate(const Shape &arg, const Vector &offset){
  Shape::impl_ptr impl = Shape::impl_ptr(new Translate_impl(getShapeImpl(arg),offset));
  return Shape(impl);
}
