/*
 * Shape.cpp
 *
 *  Created on: Jun 18, 2010
 *      Author: crueger
 */

#include "Shape.hpp"
#include "Shape_impl.hpp"

Shape::Shape(const Shape& src) :
  impl(src.getImpl())
{}

Shape::~Shape(){}

bool Shape::isInside(const Vector &point){
  return impl->isInside(point);
}

Shape::Shape(Shape::impl_ptr _impl) :
    impl(_impl)
{}

Shape &Shape::operator=(const Shape& rhs){
  if(&rhs!=this){
    impl=rhs.getImpl();
  }
  return *this;
}

Shape::impl_ptr Shape::getImpl() const{
  return impl;
}

// allows arbitrary friendship, but only if implementation is known
Shape::impl_ptr getShapeImpl(const Shape &shape){
  return shape.getImpl();
}

/***************************** Some simple Shapes ***************************/

Shape Everywhere(){
  static Shape::impl_ptr impl = Shape::impl_ptr(new Everywhere_impl());
  return Shape(impl);
}

Shape Nowhere(){
  static Shape::impl_ptr impl = Shape::impl_ptr(new Nowhere_impl());
  return Shape(impl);
}

/****************************** Operators ***********************************/

// AND

AndShape_impl::AndShape_impl(const Shape::impl_ptr &_lhs, const Shape::impl_ptr &_rhs) :
  lhs(_lhs),rhs(_rhs)
{}

AndShape_impl::~AndShape_impl(){}

bool AndShape_impl::isInside(const Vector &point){
  return lhs->isInside(point) && rhs->isInside(point);
}

Shape operator&&(const Shape &lhs,const Shape &rhs){
  Shape::impl_ptr newImpl = Shape::impl_ptr(new AndShape_impl(getShapeImpl(lhs),getShapeImpl(rhs)));
  return Shape(newImpl);
}

// OR

OrShape_impl::OrShape_impl(const Shape::impl_ptr &_lhs, const Shape::impl_ptr &_rhs) :
  lhs(_lhs),rhs(_rhs)
{}

OrShape_impl::~OrShape_impl(){}

bool OrShape_impl::isInside(const Vector &point){
  return rhs->isInside(point) || lhs->isInside(point);
}

Shape operator||(const Shape &lhs,const Shape &rhs){
  Shape::impl_ptr newImpl = Shape::impl_ptr(new OrShape_impl(getShapeImpl(lhs),getShapeImpl(rhs)));
  return Shape(newImpl);
}

// NOT

NotShape_impl::NotShape_impl(const Shape::impl_ptr &_arg) :
  arg(_arg)
{}

NotShape_impl::~NotShape_impl(){}

bool NotShape_impl::isInside(const Vector &point){
  return !arg->isInside(point);
}

Shape operator!(const Shape &arg){
  Shape::impl_ptr newImpl = Shape::impl_ptr(new NotShape_impl(getShapeImpl(arg)));
  return Shape(newImpl);
}
