# AC_SET_COMPILER_FLAGS(optimization, debugging, warnings)
#----------------------------------------------------------------
AC_DEFUN([AC_SET_COMPILER_FLAGS],[
AC_MSG_NOTICE([Using AC@&t@_SET_COMPILER_FLAGS macro])

dnl optimization
if test ! x"$1" = xno; then
	if test x"$2" = xno; then
		if test x"$1" = xyes; then
			optimization="-O2"
		else
			optimization="-O$1"
		fi
	fi
fi
dnl debugging info
if ! test x"$2" = xno; then
	if test x"$2" = xyes; then
		debugging="-g3"
	else
		debugging="-g$2"
	fi
  AC_DEFINE(HAVE_DEBUG,1, ["Output debugging info"])
  AC_SUBST(HAVE_DEBUG)
fi

dnl enable all warnings
if test x"$3" = xsome; then
	dnl even without debugging we want some minimal info of something's utterly wrong
	Cwarnings="-Wall"
	CXXwarnings="-Wall"
fi
if test x"$3" = xfull; then
	Cwarnings="-Wall -W -Wstrict-prototypes -Wmissing-prototypes -Wold-style-definition -Wshadow -Wpointer-arith -Wcast-align -Wcast-qual -Wwrite-strings -Wredundant-decls -Wnested-externs -Wmissing-noreturn -Wformat-security -Wmissing-format-attribute -Winit-self"
	CXXwarnings="-Wall -W -Wshadow -Wpointer-arith -Wcast-align -Wcast-qual -Wwrite-strings -Wredundant-decls -Wmissing-noreturn -Wformat-security -Wmissing-format-attribute -Winit-self"
fi
if test x"$3" = xnone; then
	unset Cwarnings
	unset CXXwarnings
else
	AC_DEFINE(HAVE_WARNINGS,$enable_warnings, ["Output compiler warnings"])
fi

# finally, apply whatever was set
CFLAGS="$CFLAGS $debugging $optimization $Cwarnings"
CXXFLAGS="$CXXFLAGS $debugging $optimization $CXXwarnings"

])
