/**
 * @file   interface.cpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Apr 18 12:55:48 2011
 *
 * @brief  VMG::Interface
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <algorithm>
#include <cmath>

#include "base/helper.hpp"
#include "interface/interface.hpp"

using namespace VMG;

void Interface::InitInterface(const Vector& box_offset, const vmg_float& box_size,
			      const int& coarseningSteps, const vmg_float& alpha)
{
  Index size_factor_max = 1;
  int num_cells;

  const Vector box_center = box_offset + 0.5 * box_size;

  for (int i=levelMax; i>=levelMin; --i) {

    global.push_back(GlobalIndices());
    extent.push_back(SpatialExtent());

    num_cells = Helper::intpow(2, i);

    extent.back().SizeFactor() = 1;
    extent.back().Size() = box_size;
    extent.back().Begin() = box_offset;
    extent.back().End() = box_offset + box_size;
    extent.back().MeshWidth() = box_size / num_cells;

    global.back().SizeGlobal() = num_cells + 1;
    global.back().SizeLocal() = num_cells + 1;
    global.back().BeginFinest() = 0;
    global.back().BeginLocal() = 0;
    global.back().EndLocal() = num_cells + 1;

    if (i == levelMax) {
      global.back().SizeFinest() = num_cells + 1;
      global.back().EndFinest() = num_cells + 1;
      global.back().BoundaryType() = GlobalMax;
    }else {
      global.back().SizeFinest() = (++global.rbegin())->SizeFinest();
      global.back().EndFinest() = (++global.rbegin())->SizeFinest();
      global.back().BoundaryType() = GlobalCoarsened;
    }

  }

  for (int i=0; i<3; ++i)
    if (bc[i] == Periodic)
      for (unsigned int j=0; j<global.size(); ++j) {
	global[j].SizeGlobal()[i] -= 1;
	global[j].SizeFinest()[i] -= Helper::intpow(2, j);
	global[j].SizeLocal()[i] -= 1;
	global[j].EndLocal()[i] -= 1;
	global[j].EndFinest()[i] -= Helper::intpow(2, j);
      }

  levelMin = levelMax - global.size() + 1;
}
