/**
 * @file   error_handler.hpp
 * @author Julian Iseringhausen <isering@ins.uni-bonn.de>
 * @date   Mon Nov 21 13:27:22 2011
 *
 * @brief  Convert MPI errors to C++ exceptions. Used to be
 *         able to call a debugger when MPI crashes
 *         internally.
 *
 */

#ifndef ERROR_HANDLER_HPP_
#define ERROR_HANDLER_HPP_

#ifdef HAVE_MPI

#include <stdexcept>

#include <mpi.h>

namespace VMG
{

namespace MPI
{

class Exception : public std::exception
{
public:
  Exception(const std::string& what) :
    std::exception(),
    m_what(what)
  {}

  virtual ~Exception() throw()
  {}

  const char* what() const throw()
  {
    return m_what.c_str();
  }

protected:
  std::string m_what;

};

  void ConvertToException(MPI_Comm* comm, int* err, ...);

}

}

#endif /* HAVE_MPI */

#endif /* ERROR_HANDLER_HPP_ */
