/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2011 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * CalculateMolarMassAction.cpp
 *
 *  Created on: Nov 02, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "CodePatterns/Log.hpp"

#include "Atom/atom.hpp"
#include "Element/element.hpp"
#include "World.hpp"

#include <iostream>
#include <string>

#include "CalculateMolarMassAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "CalculateMolarMassAction.def"
#include "Reaction_impl_pre.hpp"

#include "Reaction_impl.hpp"

/** =========== define the function ====================== */
double * AnalysisCalculateMolarMassAction::doCalc() {
  double mass = 0.;
  size_t totalnumber = 0;
  // calculate volume from Box
  for(World::AtomSelectionConstIterator iter = World::getInstance().beginAtomSelection();
      iter != World::getInstance().endAtomSelection();
      ++iter) {
    mass += iter->second->getType()->getMass();
    ++totalnumber;
  }
  LOG(0, "RESULT: The mass of " << totalnumber << " selected atoms is " << mass << " atomicmassunit.");

  return (new double(mass));
}
/** =========== end of function ====================== */
