/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * MatrixContainerUnitTest.cpp
 *
 *  Created on: Sep 16, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "Fragmentation/MatrixContainer.hpp"

#include "MatrixContainerUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( MatrixContainerTest );


void MatrixContainerTest::setUp()
{
  MC = new MatrixContainer();
};


void MatrixContainerTest::tearDown()
{
  delete MC;
};

/** UnitTest for operator==()
 */
void MatrixContainerTest::EqualityTest()
{
  // compare to self
  CPPUNIT_ASSERT( *MC == *MC );

  // create other instance
  MatrixContainer *MC2 = new MatrixContainer();
  CPPUNIT_ASSERT( *MC == *MC2 );
  MC2->MatrixCounter = 2;
  CPPUNIT_ASSERT( *MC != *MC2 );
  delete MC2;
};

/** UnitTest for serialization
 */
void MatrixContainerTest::SerializationTest()
{
  // write element to stream
  std::stringstream stream;
  boost::archive::text_oarchive oa(stream);
  oa << MC;

  std::cout << "Contents of archive is " << stream.str() << std::endl;

  // create and open an archive for input
  boost::archive::text_iarchive ia(stream);
  // read class state from archive
  MatrixContainer *MC2;

  ia >> MC2;

  CPPUNIT_ASSERT (*MC == *MC2);

  delete MC2;
};
