/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * KeySetsContainerUnitTest.cpp
 *
 *  Created on: Sep 16, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "Fragmentation/KeySetsContainer.hpp"

#include "KeySetsContainerUnitTest.hpp"

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( KeySetsContainerTest );


void KeySetsContainerTest::setUp()
{
  Keys = new KeySetsContainer();
};


void KeySetsContainerTest::tearDown()
{
  delete Keys;
};

/** UnitTest for operator==()
 */
void KeySetsContainerTest::EqualityTest()
{
  // compare to self
  CPPUNIT_ASSERT( *Keys == *Keys );

  // create other instance
  KeySetsContainer *Keys2 = new KeySetsContainer();
  CPPUNIT_ASSERT( *Keys == *Keys2 );
  Keys2->Order = 2;
  CPPUNIT_ASSERT( *Keys != *Keys2 );
  delete Keys2;
};

/** UnitTest for serialization
 */
void KeySetsContainerTest::SerializationTest()
{
  // write element to stream
  std::stringstream stream;
  boost::archive::text_oarchive oa(stream);
  oa << Keys;

  std::cout << "Contents of archive is " << stream.str() << std::endl;

  // create and open an archive for input
  boost::archive::text_iarchive ia(stream);
  // read class state from archive
  KeySetsContainer *Keys2;

  ia >> Keys2;

  CPPUNIT_ASSERT (*Keys == *Keys2);

  delete Keys2;
};
