/*
 * VectorSet.hpp
 *
 *  Created on: Jun 2, 2010
 *      Author: crueger
 */

#ifndef VECTORSET_HPP_
#define VECTORSET_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif



#include <functional>
#include <algorithm>
#include <limits>

/**
 * A simple mixin to give any STL conforming structure fast Vector abilities
 *
 * TODO: make this work for maps
 */

#include "Vector.hpp"
#include <vector>

// this tests, whether we actually have a Vector
template <class V>
struct is_vector{};

template <>
struct is_vector<Vector>{
  typedef void wrong_type;
};

template <class Set>
class VectorSet : public Set
{
  // when our set carries something besides a vector this will produce an error
  typedef typename is_vector<typename Set::value_type>::wrong_type check_for_vector;
public:
  // typedefs for STL conforming structure
  typedef typename Set::iterator iterator;
  typedef typename Set::const_iterator const_iterator;

  VectorSet(){}
  virtual ~VectorSet(){}

  /**
   * translate all Vectors within this set by a specified amount
   */
  void translate(const Vector &translater){
    // this is needed to allow template lookup
    transform(this->begin(),this->end(),this->begin(),std::bind1st(std::plus<Vector>(),translater));
  }

  double minDistSquared(const Vector &point){
    if(!this->size())
      return std::numeric_limits<double>::infinity();
    std::vector<double> helper;
    helper.resize(this->size());
    transform(this->begin(),this->end(),
              helper.begin(),
              std::bind2nd(std::mem_fun_ref(&Vector::DistanceSquared),point));
    return *min_element(helper.begin(),helper.end());
  }
};

// allows simpler definition of VectorSets
#define VECTORSET(container_type) VectorSet<container_type<Vector> >

#endif /* VECTORSET_HPP_ */
