/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * MoleculesCommandLineQuery.cpp
 *
 *  Created on: Oct 25, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>

#include "CommandLineUI/Query/CommandLineQuery.hpp"
#include "CommandLineUI/CommandLineParser.hpp"
#include "CodePatterns/Log.hpp"
#include "CodePatterns/Verbose.hpp"
#include "World.hpp"

CommandLineDialog::MoleculesCommandLineQuery::MoleculesCommandLineQuery(Parameter<std::vector<const molecule *> > &_param, std::string title, std::string _description) :
    Dialog::TQuery<std::vector<const molecule *> >(_param, title, _description)
{}

CommandLineDialog::MoleculesCommandLineQuery::~MoleculesCommandLineQuery() {}

bool CommandLineDialog::MoleculesCommandLineQuery::handle() {
  std::vector<int> IdxOfMol;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    try {
      IdxOfMol = CommandLineParser::getInstance().vm[getTitle()].as< std::vector<int> >();
    } catch(boost::bad_any_cast &e) {
      IdxOfMol.clear();
      return false;
    }
    for (std::vector<int>::iterator iter = IdxOfMol.begin(); iter != IdxOfMol.end(); ++iter) {
      const molecule *temp_element = World::getInstance().getMolecule(MoleculeById(*iter));
      if (temp_element)
        temp.push_back(temp_element);
    }
    return true;
  }
  return false;
}

