/*
 * LinkedCellUnitTest.cpp
 *
 *  Created on: Apr 9, 2010
 *      Author: heber
 */

using namespace std;

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <iostream>
#include <stdio.h>
#include <cstring>

#include "atom.hpp"
#include "element.hpp"
#include "linkedcell.hpp"
#include "molecule.hpp"
#include "periodentafel.hpp"
#include "LinkedCellUnitTest.hpp"

/********************************************** Test classes **************************************/

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( LinkedCellTest );


void LinkedCellTest::setUp()
{
  atom *Walker = NULL;

  // init private all pointers to zero
  TestMolecule = NULL;
  hydrogen = NULL;
  tafel = NULL;

  // construct element
  hydrogen = new element;
  hydrogen->Z = 1;
  hydrogen->CovalentRadius = 0.23;
  strcpy(hydrogen->name, "hydrogen");
  strcpy(hydrogen->symbol, "H");

  // construct periodentafel
  tafel = new periodentafel;
  tafel->AddElement(hydrogen);

  // construct molecule (water molecule)
  TestMolecule = new molecule(tafel);
  Walker = new atom();
  Walker->type = hydrogen;
  Walker->node->Init(0., 0., 0. );
  TestMolecule->AddAtom(Walker);

  // check that TestMolecule was correctly constructed
  CPPUNIT_ASSERT_EQUAL( TestMolecule->AtomCount, 1 );
  Walker = TestMolecule->start->next;
  CPPUNIT_ASSERT( TestMolecule->end != Walker );

  // construct linked cell
  LC = new LinkedCell (TestMolecule, 1.);
};


void LinkedCellTest::tearDown()
{
  delete(LC);
  delete(TestMolecule);
  // note that all the atoms are cleaned by TestMolecule
  delete(tafel);
  // note that element is cleaned by periodentafel
};


/** UnitTest for LinkedCell::GetCurrentCell().
 */
void LinkedCellTest::GetCurrentCellTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};

/** UnitTest for LinkedCell::GetRelativeToCurrentCell().
 */
void LinkedCellTest::GetRelativeToCurrentCellTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::SetIndexToNode().
 */
void LinkedCellTest::SetIndexToNodeTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::SetIndexToVector().
 */
void LinkedCellTest::SetIndexToVectorTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::CheckBounds().
 */
void LinkedCellTest::CheckBoundsTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::GetNeighbourBounds().
 */
void LinkedCellTest::GetNeighbourBoundsTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::GetallNeighbours().
 */
void LinkedCellTest::GetallNeighboursTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};


/** UnitTest for LinkedCell::GetPointsInsideSphere().
 */
void LinkedCellTest::GetPointsInsideSphereTest()
{
  CPPUNIT_ASSERT_EQUAL( true, true );
};

/********************************************** Main routine **************************************/

int main(int argc, char **argv)
{
  // Get the top level suite from the registry
  CppUnit::Test *suite = CppUnit::TestFactoryRegistry::getRegistry().makeTest();

  // Adds the test to the list of test to run
  CppUnit::TextUi::TestRunner runner;
  runner.addTest( suite );

  // Change the default outputter to a compiler error format outputter
  runner.setOutputter( new CppUnit::CompilerOutputter( &runner.result(),
                                                       std::cerr ) );
  // Run the tests.
  bool wasSucessful = runner.run();

  // Return error code 1 if the one of test failed.
  return wasSucessful ? 0 : 1;
};

