/*
 * ShapeFactory.hpp
 *
 *  Created on: Sep 5, 2012
 *      Author: ankele
 */

#ifndef SHAPEFACTORY_HPP_
#define SHAPEFACTORY_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/Singleton.hpp"
#include "LinearAlgebra/Vector.hpp"

#include "Shape.hpp"

class ShapeFactory : public Singleton<ShapeFactory>
{
  friend class Singleton<ShapeFactory>;

public:

  ShapeType getShapeByName(const std::string &name);
  std::string getShapeName(ShapeType type);
  const std::vector<std::string> &getBaseShapeNames();
  bool isValidShapeName(const std::string &name);

  // create a shape
  Shape produce(ShapeType type, const Vector &translation = Vector(0., 0., 0.), const Vector &stretch = Vector(1., 1., 1.), double angleX = 0, double angleY = 0, double angleZ = 0) const;

private:
  // private constructor and destructor due to singleton
  ShapeFactory();
  virtual ~ShapeFactory();

  // name/type maps
  static const char *shapeNames[];
  std::vector<std::string> baseShapeNames;
  typedef std::map<ShapeType, std::string> ShapeNameMap;
  ShapeNameMap shapeNameMap;
  typedef std::map<std::string,ShapeType> NameShapeMap;
  NameShapeMap nameShapeMap;
};

#endif /* SHAPEFACTORY_HPP_ */
