/*
 * ShapeTypeValidator.hpp
 *
 *  Created on: Sep 6, 2012
 *      Author: ankele
 */

#ifndef SHAPETYPEVALIDATOR_HPP_
#define SHAPETYPEVALIDATOR_HPP_



// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "Parameters/Validators/DiscreteValidator.hpp"

/** This validator checks whether the given string is a shape type
 * (i.e. "sphere" etc).
 */
class ShapeTypeValidator : public DiscreteValidator<std::string>
{
public:
  ShapeTypeValidator();
  bool isValid(const std::string & _value) const;
  virtual const std::vector<std::string> &getValidValues() const;
  bool operator==(const Validator<std::string> &_instance) const;
  Validator< std::string >* clone() const;
};



#endif /* SHAPETYPEVALIDATOR_HPP_ */
