/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ShapeTypeValidator.cpp
 *
 *  Created on: Sep 6, 2012
 *      Author: ankele
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "ShapeTypeValidator.hpp"

#include "Shapes/ShapeFactory.hpp"

ShapeTypeValidator::ShapeTypeValidator() :
DiscreteValidator<std::string>(std::vector<std::string>())
{}

bool ShapeTypeValidator::isValid(const std::string & _value) const
{
  return ShapeFactory::getInstance().isValidShapeName(_value);
}

const std::vector<std::string> &ShapeTypeValidator::getValidValues() const
{
  return ShapeFactory::getInstance().getBaseShapeNames();
}

bool ShapeTypeValidator::operator==(const Validator<std::string> &_instance) const
{
  const ShapeTypeValidator *inst =
      dynamic_cast<const ShapeTypeValidator *>(&_instance);
  if (inst)
    return true;
  else
    return false;
}

Validator< std::string >* ShapeTypeValidator::clone() const
{
  Validator< std::string > *inst =
      new ShapeTypeValidator();
  return inst;
}





