/*
 * DiscreteValidator.hpp
 *
 *  Created on: Apr 13, 2012
 *      Author: ankele
 */

#ifndef DISCRETEVALIDATOR_HPP_
#define DISCRETEVALIDATOR_HPP_


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Validator.hpp"

#include <vector>

class DiscreteValueTest;
class ParameterValidatorException;

/** A validator with a discrete list of valid values.
 *
 */
template <class T>
class DiscreteValidator : public Validator<T>
{
  //!> unit test needs to have access to internal values
  friend class DiscreteValueTest;
public:
  DiscreteValidator(const std::vector<T> &_ValidValues) : ValidValues(_ValidValues) {};
  virtual ~DiscreteValidator() {};

  bool isValid(const T & _value) const;

  Validator<T>* clone() const;

  // comparator
  bool operator==(const Validator<T> &_instance) const;

  void appendValidValue(const T &_value) throw(ParameterValidatorException);
  virtual const std::vector<T> &getValidValues() const;

private:
  const size_t findIndexOfValue(const T &_value) const;

private:
  //!> list of valid values
  std::vector<T> ValidValues;
};

#include "DiscreteValidator_impl.hpp"

#endif /* DISCRETEVALIDATOR_HPP_ */
