/** \file defs.hpp
 * 
 * Constant definitons and enumerations.
 * 
 */

#ifndef DEFS_HPP_
#define DEFS_HPP_

using namespace std;

#define MYEPSILON 1e-13   //!< machine epsilon precision
#define NDIM  3   //!< number of spatial dimensions
#define MAX_ELEMENTS 128  //!< maximum number of elements for certain lookup tables 
#define AtomicLengthToAngstroem  0.52917721 //!< conversion factor from atomic length/bohrradius to angstroem
#define BONDTHRESHOLD 0.5   //!< CSD threshold in bond check which is the width of the interval whose center is the sum of the covalent radii 

#define VERSIONSTRING "v1.0"

#define LocalPath "./"

//enum BondOrderScheme { NoScheme, BottomUp, TopDown, ANOVA, Combined }; //!< Fragmentation scheme used in BOSS

enum EdgeType { Undetermined, TreeEdge, BackEdge }; //!< edge type in a graph after Depth-First-Search analysis.

enum Shading { white, lightgray, darkgray, black };  //!< color in Breadth-First-Search analysis

//enum CutCyclicBond { KeepBond,  SaturateBond }; //!< Saturation scheme either atom- or bondwise 

// Specifting whether a value in the parameter file must be specified or is optional
enum necessity { optional,    //!< parameter is optional, if not given sensible value is chosen
                 critical     //!< parameter must be given or programme won't initiate
               };

// Specifying the status of the on command line given config file
enum ConfigStatus { absent, empty, present };

// Specifying the cast type to be read of a parameter, see ParseForParameter()
enum value_type { string_type, double_type, int_type, row_int, row_double, grid, lower_trigrid, upper_trigrid}; 

// maximum length of any char array
#define MAXSTRINGSIZE 255

// various standard filenames
#define DEFAULTCONFIG "main_pcp_linux"    //!< default filename of config file
#define CONVEXENVELOPE "ConvexEnvelope.dat"    //!< default filename of convex envelope tecplot data file
#define KEYSETFILE "KeySets.dat"    //!< default filename of BOSSANOVA key sets file
#define ADJACENCYFILE "Adjacency.dat"    //!< default filename of BOSSANOVA adjacancy file
#define TEFACTORSFILE "TE-Factors.dat"    //!< default filename of BOSSANOVA total energy factors file
#define FORCESFILE "Forces-Factors.dat"    //!< default filename of BOSSANOVA force factors file
#define HCORRECTIONSUFFIX "Hcorrection.dat"    //!< default filename of BOSSANOVA H correction file (unwanted saturation interaction)
#define FITCONSTANTSUFFIX "FitConstant.dat"   //!< suffix of default filename of BOSSANOVA fit constants file (unwanted saturation interaction)
#define SHIELDINGSUFFIX "sigma_all.csv"                //!< default filename of BOSSANOVA shieldings file
#define SHIELDINGPASSUFFIX "sigma_all_PAS.csv"                 //!< default filename of BOSSANOVA shieldings PAS file
#define ORDERATSITEFILE "OrderAtSite.dat"    //!< default filename of BOSSANOVA Bond Order at each atom file
#define ENERGYPERFRAGMENT "EnergyPerFragment"    //!< default filename of BOSSANOVA Energy contribution Per Fragment file
#define FRAGMENTPREFIX "BondFragment"    //!< default filename prefix of BOSSANOVA fragment config and directories 
#define STANDARDCONFIG "unknown.conf"    //!< default filename of standard config file
#define STANDARDELEMENTSDB "elements.db"    //!< default filename of elements data base with masses, Z, VanDerWaals radii, ...
#define STANDARDVALENCEDB "valence.db"    //!< default filename of valence number per element database
#define STANDARDORBITALDB "orbitals.db"    //!< default filename of orbitals per element database
#define STANDARDHBONDDISTANCEDB "Hbonddistance.db"    //!< default filename of typial bond distance to hydrogen database
#define STANDARDHBONDANGLEDB "Hbondangle.db"    //!< default filename of typial bond angle to hydrogen database

// some values
#define SOLVENTDENSITY_A 0.6022142
#define SOLVENTDENSITY_a0 0.089238936


#define UPDATECOUNT 10  //!< update ten sites per BOSSANOVA interval

#endif /*DEFS_HPP_*/
