/*
 * SubsetMapUnitTest.hpp
 *
 *  Created on: Jul 3, 2012
 *      Author: heber
 */

#ifndef SUBSETMAPUNITTEST_HPP_
#define SUBSETMAPUNITTEST_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <cppunit/extensions/HelperMacros.h>

#include <vector>

#include "Fragmentation/Summation/IndexSet.hpp"
#include "Fragmentation/Summation/SubsetMap.hpp"

/********************************************** Test classes **************************************/

class SubsetMapTest : public CppUnit::TestFixture
{
    CPPUNIT_TEST_SUITE( SubsetMapTest) ;
    CPPUNIT_TEST ( getNoPowerSetsTest );
    CPPUNIT_TEST ( getPowerSetIndexTest );
    CPPUNIT_TEST ( getSubsetTest );
    CPPUNIT_TEST ( gatherSubsetTest );
    CPPUNIT_TEST ( getMaximumSubsetLevelTest );
    CPPUNIT_TEST_SUITE_END();

public:
      void setUp();
      void tearDown();
      void getNoPowerSetsTest();
      void getPowerSetIndexTest();
      void getSubsetTest();
      void gatherSubsetTest();
      void getMaximumSubsetLevelTest();

private:
      SubsetMap *SM;
      std::vector<IndexSet> allsets;
};

#endif /* SUBSETMAPUNITTEST_HPP_ */
