/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 * 
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * HelpAction.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

#include <iostream>
#include <string>

#include "Actions/ActionQueue.hpp"
#include "Actions/ActionTrait.hpp"
#include "Actions/OptionRegistry.hpp"
#include "Actions/OptionTrait.hpp"
#include "CodePatterns/Log.hpp"

#include "Actions/CommandAction/HelpAction.hpp"

using namespace MoleCuilder;

// and construct the stuff
#include "HelpAction.def"
#include "Action_impl_pre.hpp"
/** =========== define the function ====================== */
ActionState::ptr CommandHelpAction::performCall() {
  // print some general advice
  std::cout << std::endl << std::endl << "Usage help:" << std::endl;
  std::cout << "================================================================================" << std::endl;
  std::cout << "Usage: molecuilder --<action name> [arguments] [--<option1 name> <argument> ...]" << std::endl;
  std::cout << std::endl;
  std::cout << "MoleCuilder can do all kinds of measurements and manipulations and it always"  << std::endl;
  std::cout << "works on files! See action 'input' and 'set-output' on how to specify these." << std::endl;
  std::cout << std::endl;
  std::cout << "To get a list of all actions, use " << std::endl;
  std::cout << "\t'molecuilder --help'." << std::endl;
  std::cout << "To get all options for a specific action, use " << std::endl;
  std::cout << "\t'molecuilder --help --actionname \"<actionname>\"'." << std::endl;
  std::cout << std::endl;
  std::cout << "Arguments are given in the following (peculiar) ways:" << std::endl;
  std::cout << "\t - Boolean: give as 0 (false) or 1 (true)." << std::endl;
  std::cout << "\t - Integer: give as e.g. 17" << std::endl;
  std::cout << "\t - Double: give as e.g. 0.5346" << std::endl;
  std::cout << "\t - String: give as e.g. \"test\"" << std::endl;
  std::cout << "\t - List/vector of strings: gives as \"first\" \"second\" \"third\"." << std::endl;
  std::cout << "\t - Vector: give as \"x,y,z\", i.e. its 3 components." << std::endl;
  std::cout << "\t -         or give as \"<name>\", where <name> is a stored geometry name." << std::endl;
  std::cout << "\t - Domain: give as \"xx,yx,yy,zx,zy,zz\", i.e. symmetric 3x3 matrix." << std::endl;
  std::cout << "\t - Path/filename: give as \"<path/filename>\"." << std::endl;
  std::cout << "================================================================================" << std::endl;
  std::cout << std::endl;
  // print list of actions or its options
  ActionQueue &AQ = ActionQueue::getInstance();
  ActionQueue::ActionTokens_t tokens = AQ.getListOfActions();
  if (params.actionname.get() == std::string("none")) {
    // print list of all Actions
    std::cout << "Here is a list of all available Actions:" << std::endl;
    for(ActionQueue::ActionTokens_t::const_iterator iter = tokens.begin();
        iter != tokens.end();
        ++iter) {
      std::cout << "'" << *iter << "': \t "
          << AQ.getActionsTrait(*iter).getDescription() << std::endl;
    }
  } else {
    // retrieve command from Registry and print its help
    if (AQ.isActionKnownByName(params.actionname.get())) {
      const Action &instance = AQ.getActionByName(params.actionname.get());
      // else give description of Action and its option value if present
      std::cout << instance.help();
      std::cout << std::endl;
      std::cout << std::endl;
    } else {
      STATUS("No action is known by the name "+params.actionname.get()+".");
      return Action::failure;
    }

  }

  return Action::success;
}

ActionState::ptr CommandHelpAction::performUndo(ActionState::ptr _state) {
  return Action::success;
}

ActionState::ptr CommandHelpAction::performRedo(ActionState::ptr _state){
  return Action::success;
}

bool CommandHelpAction::canUndo() {
  return true;
}

bool CommandHelpAction::shouldUndo() {
  return false;
}
/** =========== end of function ====================== */
