/*
 * FragmentController.hpp
 *
 *  Created on: Nov 27, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_HPP_
#define FRAGMENTCONTROLLER_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"
#include "FragmentJob.hpp"
#include "FragmentResult.hpp"

/** The FragmentController sends bunches of jobs to a FragmentScheduler,
 *  waits for their calculation and is called when they are done. Then,
 *  he loads the bunch of results from the Scheduler.
 *
 * While the FragmentScheduler and FragmentWorker rather act on their own
 * this is the piece to implant into the user software to allow for
 * communication with the Server/Worker duo to perform the calculation
 * of the fragments on distant computers.
 */
class FragmentController
{
public:
  FragmentController(boost::asio::io_service& io_service, const std::string& host, const std::string& service);
  ~FragmentController();

  /// Handle completion of a accept operation.
  void handle_connect_calc(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when bunch of jobs have been sent.
  void handle_SendJobs(const boost::system::error_code& e);

  /// place number of jobs into this controller
  void addJobs(const std::vector<FragmentJob> &jobs);

  /// prepares the calculation of the results
  void calculateResults();
  
  enum Exitflag_t {
    OkFlag = 0,
    ErrorFlag = 255
  };

  // get the exit flag of the last operations
  size_t getExitflag() const
  {
    return Exitflag;
  }

private:
  /// internal function to resolve host name and ip address
  boost::asio::ip::tcp::resolver::iterator getEndpointIterator();

  /// internal function to connect to server and send jobs for calculating jobs
  void connect_calc();

  /// internal function to disconnect from server
  void disconnect();

private:
  /// The Connection to the server.
  Connection connection_;

  /// host name of server
  const std::string host;

  // service to connect to to
  const std::string service;

  /// bunch of jobs
  std::vector<FragmentJob> jobs;

  /// flag to give on program exit
  enum Exitflag_t Exitflag;
};

#endif /* FRAGMENTCONTROLLER_HPP_ */
