/*
 * TesselationHelpers.hpp
 *
 *  Auxiliary functions for the tesselation.
 *
 *  Created on: Aug 3, 2009
 *      Author: heber
 */

#ifndef TESSELATIONHELPERS_HPP_
#define TESSELATIONHELPERS_HPP_

using namespace std;

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gsl/gsl_linalg.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_multimin.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_vector.h>

#include "defs.hpp"
#include "tesselation.hpp"
#include "vector.hpp"

#define HULLEPSILON 1e-10

double DetGet(gsl_matrix *A, int inPlace);
void GetSphere(Vector *center, Vector &a, Vector &b, Vector &c, double RADIUS);
void GetCenterOfSphere(Vector* Center, Vector a, Vector b, Vector c, Vector *NewUmkreismittelpunkt, Vector* Direction, Vector* AlternativeDirection, double HalfplaneIndicator, double AlternativeIndicator, double alpha, double beta, double gamma, double RADIUS, double Umkreisradius);
void GetCenterofCircumcircle(Vector *Center, Vector *a, Vector *b, Vector *c);
double GetPathLengthonCircumCircle(Vector &CircleCenter, Vector &CirclePlaneNormal, double CircleRadius, Vector &NewSphereCenter, Vector &OldSphereCenter, Vector &NormalVector, Vector &SearchDirection);
double MinIntersectDistance(const gsl_vector * x, void *params);
bool existsIntersection(Vector point1, Vector point2, Vector point3, Vector point4);
double CalculateVolumeofGeneralTetraeder(Vector *a, Vector *b, Vector *c, Vector *d);
double GetAngle(const Vector &point, const Vector &reference, const Vector OrthogonalVector);

bool CheckLineCriteriaForDegeneratedTriangle(class BoundaryPointSet *nodes[3]);
bool SortCandidates(class CandidateForTesselation* candidate1, class CandidateForTesselation* candidate2);
TesselPoint* FindClosestPoint(const Vector* Point, TesselPoint *&SecondPoint, LinkedCell* LC);
TesselPoint* FindSecondClosestPoint(const Vector*, LinkedCell*);
Vector * GetClosestPointBetweenLine(ofstream *out, class BoundaryLineSet *Base, class BoundaryLineSet *OtherBase);

void WriteTecplotFile(ofstream *out, ofstream *tecplot, class Tesselation *TesselStruct, PointCloud *cloud, int N);
void WriteRaster3dFile(ofstream *out, ofstream *rasterfile, class Tesselation *Tess, PointCloud *cloud);
void IncludeSphereinRaster3D(ofstream *out, ofstream *rasterfile, class Tesselation *Tess, PointCloud *cloud);
void WriteVrmlFile(ofstream *out, ofstream *vrmlfile, class Tesselation *Tess, PointCloud *cloud);
void CalculateConcavityPerBoundaryPoint(ofstream *out, class Tesselation *TesselStruct);

bool CheckListOfBaselines(ofstream *out, Tesselation *TesselStruct);


#endif /* TESSELATIONHELPERS_HPP_ */
