/*
 * GLMoleculeObject_bond.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_BOND_HPP_
#define GLMOLECULEOBJECT_BOND_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include "Bond/bond.hpp"
#include "types.hpp"

class atom;

class GLWorldScene;

class GLMoleculeObject_bond : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  enum SideOfBond { left, right };

  GLMoleculeObject_bond(QGLSceneNode *mesh[], QObject *parent, const bond::ptr bondref, const enum SideOfBond side);
  virtual ~GLMoleculeObject_bond();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

signals:
  void BondRemoved(const atomId_t leftnr, const atomId_t rightnr);

private:
  //!> grant WorldScene access to reset functions
  friend class GLWorldScene;

  /** Recalculates the position of the cylinder representing the bond.
   *
   */
  void resetPosition();

  /** Recalculates the width of the cylinder representing the bond's degree.
   *
   */
  void resetWidth();

  /** This must be called from subjectKilled() only.
   *
   * We remove from all other Observables in a controlled manner.
   * However, we assume that either bond, leftobservable, or rightobservable
   * called subjectKilled(). Hence, we may still signOff() from all noifications
   * but not from the calling Observable.
   *
   * removeLeftAtom(), removeRightAtom(), removeBond(), and removeChannels()
   * must have been called before (or one of the subjects has been killed).
   *
   */
  void removeMe();
  void removeLeftAtom();
  void removeRightAtom();
  void removeChannels();
  void removeBond();

private:
  const bond& _bond;
  /** Observable instance inside atom_observable for left bond partner.
   * We require this knowledge as subjectKilled is called by Observable, not
   * by AtomObservable which has already been destroyed at this time.
   *
   */
  const Observable *leftobservable;
  /** Observable instance inside atom_observable for right bond partner.
   * We require this knowledge as subjectKilled is called by Observable, not
   * by AtomObservable which has already been destroyed at this time.
   *
   */
  const Observable *rightobservable;
  //!> id of left bond partner for safely emitting BondRemoved sigbal
  const atomId_t leftatomId;
  //!> id of right bond partner for safely emitting BondRemoved sigbal
  const atomId_t rightatomId;
  const enum SideOfBond BondSide;

  //!> indicate whether we are signed in to leftobservable
  bool leftobservable_enabled;
  //!> indicate whether we are signed in to rightobservable
  bool rightobservable_enabled;
  //!> indicate whether we are signed in to _bond
  bool bond_enabled;
};



#endif /* GLMOLECULEOBJECT_BOND_HPP_ */
