/*
 * GLMoleculeObject_atom.hpp
 *
 *  Created on: Aug 17, 2011
 *      Author: heber
 */

#ifndef GLMOLECULEOBJECT_ATOM_HPP_
#define GLMOLECULEOBJECT_ATOM_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "GLMoleculeObject.hpp"

#include "CodePatterns/Observer/Observer.hpp"

#include "Bond/bond.hpp"
#include "UIElements/Views/Qt4/Qt3D/GLMoleculeObject_bond.hpp"
#include "types.hpp"

class GLWorldScene;

class GLMoleculeObject_atom : public GLMoleculeObject, public Observer
{
  Q_OBJECT
public:
  GLMoleculeObject_atom(QGLSceneNode *mesh[], QObject *parent, const atomId_t id);
  virtual ~GLMoleculeObject_atom();

  // Observer functions
  void update(Observable *publisher);
  void subjectKilled(Observable *publisher);
  void recieveNotification(Observable *publisher, Notification_ptr notification);

private slots:
  void wasClicked();

signals:
  void clicked(atomId_t);
  void BondsInserted(const bond::ptr _bond, const GLMoleculeObject_bond::SideOfBond side);
  void indexChanged(GLMoleculeObject_atom *ob, int oldId, int newId);

private:
  //!> grant GLWorldScene acess to reset functions
  friend class GLWorldScene;

  void resetPosition();

private:
  void resetElement();
  void resetIndex();
  void resetProperties();

  const atomId_t atomicid;
};



#endif /* GLMOLECULEOBJECT_ATOM_HPP_ */
