/*
 * FragmentJobStub.hpp
 *
 *  Created on: Feb 06, 2012
 *      Author: heber
 */

#ifndef FRAGMENTJOBSTUB_HPP_
#define FRAGMENTJOBSTUB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "boost/serialization/export.hpp"

#include "Jobs/FragmentJob.hpp"

struct FragmentJobStub : public FragmentJob
{
  FragmentJobStub(const JobId_t _JobId);

  FragmentResult::ptr Work();

private:
  //!> private default cstor for serialization only
  FragmentJobStub();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(FragmentJobStub)

#endif /* FRAGMENTJOBSTUB_HPP_ */
