/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2012 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentJobStub.cpp
 *
 *  Created on: Feb 06, 2012
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

// include headers that implement a archive in simple text format
// otherwise BOOST_CLASS_EXPORT_IMPLEMENT has no effect
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include "FragmentJobStub.hpp"

#include "Results/FragmentResult.hpp"
#include "JobId.hpp"

FragmentJobStub::FragmentJobStub(const JobId_t _JobId) :
  FragmentJob(_JobId)
{}

FragmentResult::ptr FragmentJobStub::Work() {
  return FragmentResult::ptr( new FragmentResult(getId()) );
}

//!> private default cstor for serialization only
FragmentJobStub::FragmentJobStub() :
  FragmentJob(JobId::IllegalJob)
{}

// we need to explicitly instantiate the serialization functions as
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_IMPLEMENT(FragmentJobStub)

