/*
 * SystemCommandJob.hpp
 *
 *  Created on: Feb 5, 2011
 *      Author: heber
 */

#ifndef SYSTEMCOMMANDJOB_HPP_
#define SYSTEMCOMMANDJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/serialization/export.hpp>

#include <string>

#include "Jobs/FragmentJob.hpp"

class SystemCommandJobTest;

/** SystemCommandJob is an extension of FragmentJob that executes a system
 * command operating onto a specific outputfile.
 *
 * Implement extractResult() to get the desired result from the captured
 * output of the system command.
 *
 * Important is that this class is fully serializable such that it can be
 * transfered to a scheduler (server) and be deserialized by the Worker.
 */
class SystemCommandJob : public FragmentJob
{
  //!> grant unit test access
  friend class SystemCommandJobTest;
public:
  SystemCommandJob(const std::string &_command, const std::string &_outputfile, const JobId_t _JobId);
  ~SystemCommandJob();

  FragmentResult::ptr Work();

  bool operator==(const SystemCommandJob &other) const;

  bool operator!=(const SystemCommandJob &other) const {
    return !(*this == other);
  }

private:
  virtual FragmentResult::ptr extractResult(const std::string &resultstring);

  //!> string containing the command to launch the solver
  std::string command;

  //!> string containing the configuration file for the solver
  std::string outputfile;

protected:
  //!> private default cstor for serialization only
  SystemCommandJob();

private:
  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<FragmentJob>(*this);
    ar & command;
    ar & outputfile;
  }
};

// we need to give this class a unique key for serialization
// its is only serialized through its base class FragmentJob
BOOST_CLASS_EXPORT_KEY(SystemCommandJob)

#endif /* SYSTEMCOMMANDJOB_HPP_ */
