/*
 * FragmentJob.hpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

#ifndef FRAGMENTJOB_HPP_
#define FRAGMENTJOB_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include "boost/shared_ptr.hpp"
#include "boost/serialization/access.hpp"
#include "boost/serialization/shared_ptr.hpp"

#include "Results/FragmentResult.hpp"
#include "JobId.hpp"
#include "types.hpp"

class FragmentJobTest;
class FragmentQueueTest;
class FragmentWorker;

/** FragmentJob contains all information for the Worker to start the job and
 * deliver a FragmentResult.
 *
 * Important is that this class is fully serializable such that it can be
 * transfered to a scheduler (server) and be deserialized by the Worker.
 */
class FragmentJob : public JobId
{
  //!> allow FragmentQueue unit test access
  friend class FragmentQueueTest;
  //!> allow own unit test access
  friend class FragmentJobTest;
public:
  typedef boost::shared_ptr<FragmentJob> ptr;

  FragmentJob(const JobId_t _JobId);
  ~FragmentJob();

  virtual FragmentResult::ptr Work() = 0;

  bool operator==(const FragmentJob &other) const;

  bool operator!=(const FragmentJob &other) const {
    return !(*this == other);
  }

private:
  /** private default cstor for serialization only
   *
   * Use normal cstor with JobId::IllegalJob if you want to instantiate
   * a job without id.
   */
  FragmentJob();

  friend class boost::serialization::access;
  // serialization
  template <typename Archive>
  void serialize(Archive& ar, const unsigned int version)
  {
    ar & boost::serialization::base_object<JobId>(*this);
  }
};


#endif /* FRAGMENTJOB_HPP_ */
