/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010 University of Bonn. All rights reserved.
 * Please see the LICENSE file or "Copyright notice" in builder.cpp for details.
 */

/*
 * FragmentJob.cpp
 *
 *  Created on: Oct 19, 2011
 *      Author: heber
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CodePatterns/MemDebug.hpp"

#include "FragmentJob.hpp"
#include "Results/FragmentResult.hpp"

/** Constructor for class FragmentJob.
 *
 */
FragmentJob::FragmentJob() :
  JobId(JobId::IllegalJob)
{}

/** Constructor for class FragmentJob.
 *
 * \param _JobId unique id of this job
 */
FragmentJob::FragmentJob(const JobId_t _JobId) :
  JobId(_JobId)
{}

/** Destructor for class FragmentJob.
 *
 */
FragmentJob::~FragmentJob()
{}

/** Comparator for class FragmentJob.
 * \param other instance to compare to
 * \return every member variable is the same, else - is not
 */
bool FragmentJob::operator==(const FragmentJob &other) const
{
  return (getId() == other.getId());
}
