/*
 * CommandLineDialog.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */


#include <cassert>
#include <iostream>

#include <Descriptors/MoleculeDescriptor.hpp>
#include <Descriptors/MoleculeIdDescriptor.hpp>
#include "UIElements/CommandLineDialog.hpp"

#include "periodentafel.hpp"
#include "atom.hpp"
#include "CommandLineParser.hpp"
#include "defs.hpp"
#include "molecule.hpp"
#include "log.hpp"
#include "verbose.hpp"
#include "World.hpp"

using namespace std;


CommandLineDialog::CommandLineDialog()
{
}

CommandLineDialog::~CommandLineDialog()
{
}


void CommandLineDialog::queryInt(const char* title, int* target){
  registerQuery(new IntTextQuery(title,target));
}

void CommandLineDialog::queryDouble(const char* title, double* target){
  registerQuery(new DoubleTextQuery(title,target));
}

void CommandLineDialog::queryString(const char* title, string* target){
  registerQuery(new StringTextQuery(title,target));
}

void CommandLineDialog::queryMolecule(const char* title, molecule **target, MoleculeListClass *molecules) {
  registerQuery(new MoleculeTextQuery(title,target,molecules));
}

void CommandLineDialog::queryVector(const char* title, Vector *target,const double *const cellSize, bool check) {
  registerQuery(new VectorTextQuery(title,target,cellSize,check));
}

void CommandLineDialog::queryElement(const char* title, const element **target){
  registerQuery(new ElementTextQuery(title,target));
}

/************************** Query Infrastructure ************************/

CommandLineDialog::IntTextQuery::IntTextQuery(string title,int *_target) :
    Dialog::IntQuery(title,_target)
{}

CommandLineDialog::IntTextQuery::~IntTextQuery() {}

bool CommandLineDialog::IntTextQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    return true;
  } else
    return false;
}

CommandLineDialog::StringTextQuery::StringTextQuery(string title,string *_target) :
    Dialog::StringQuery(title,_target)
{}

CommandLineDialog::StringTextQuery::~StringTextQuery() {}

bool CommandLineDialog::StringTextQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as<std::string>();
    return true;
  } else
    return false;
}

CommandLineDialog::DoubleTextQuery::DoubleTextQuery(string title,double *_target) :
    Dialog::DoubleQuery(title,_target)
{}

CommandLineDialog::DoubleTextQuery::~DoubleTextQuery() {}

bool CommandLineDialog::DoubleTextQuery::handle() {
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    tmp = CommandLineParser::getInstance().vm[getTitle()].as<double>();
    return true;
  } else
    return false;
}

CommandLineDialog::MoleculeTextQuery::MoleculeTextQuery(string title, molecule **_target, MoleculeListClass *_molecules) :
    Dialog::MoleculeQuery(title,_target,_molecules)
{}

CommandLineDialog::MoleculeTextQuery::~MoleculeTextQuery() {}

bool CommandLineDialog::MoleculeTextQuery::handle() {
  int IdxOfMol = -1;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    IdxOfMol = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    tmp = World::getInstance().getMolecule(MoleculeById(IdxOfMol));
    return true;
  } else
    return false;
}

CommandLineDialog::VectorTextQuery::VectorTextQuery(std::string title, Vector *_target, const double *const _cellSize, bool _check) :
    Dialog::VectorQuery(title,_target,_cellSize,_check)
{}

CommandLineDialog::VectorTextQuery::~VectorTextQuery()
{}

bool CommandLineDialog::VectorTextQuery::handle() {
  vector<double> temp;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    temp = CommandLineParser::getInstance().vm[getTitle()].as<vector<double> >();
    assert((temp.size() == 3) && "Vector from command line does not have three components.");
    tmp = new Vector;
    for (int i=0;i<NDIM;i++)
      tmp->at(i) = temp[i];
    return true;
  } else
    return false;
}


CommandLineDialog::ElementTextQuery::ElementTextQuery(std::string title, const element **target) :
    Dialog::ElementQuery(title,target)
{}

CommandLineDialog::ElementTextQuery::~ElementTextQuery()
{}

bool CommandLineDialog::ElementTextQuery::handle() {
  int Z = -1;
  if (CommandLineParser::getInstance().vm.count(getTitle())) {
    Z = CommandLineParser::getInstance().vm[getTitle()].as<int>();
    tmp = World::getInstance().getPeriode()->FindElement(Z);
    return true;
  } else
    return false;
}
