/*
 * CommandLineWindow.cpp
 *
 *  Created on: May 8, 2010
 *      Author: heber
 */

#include <boost/bind.hpp>

#include "UIElements/CommandLineWindow.hpp"
#include "UIElements/CommandLineStatusIndicator.hpp"

#include "Actions/CmdAction/HelpAction.hpp"
#include "Actions/ParserAction/LoadXyzAction.hpp"
#include "Actions/ParserAction/SaveXyzAction.hpp"

#include <iostream>

using namespace std;

// TODO: see what code can be moved to a base class for Graphic and CommandLine Windows
CommandLineWindow::CommandLineWindow()
{
  // create and register all command line callable actions
  populateParserActions();

  // Add status indicators etc...
  statusIndicator = new CommandLineStatusIndicator();
}

CommandLineWindow::~CommandLineWindow()
{
  delete statusIndicator;
}

void CommandLineWindow::display() {
}

void CommandLineWindow::populateParserActions()
{
  new ParserLoadXyzAction();
  new ParserSaveXyzAction();
}

