/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2017 Frederik Heber. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * DiffFragmentResultContainer.cpp
 *
 *  Created on: Apr 5, 2017
 *      Author: heber
 */


// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

//#include "CodePatterns/MemDebug.hpp"

// include headers that implement a archive in simple text format
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/path.hpp>
#include <boost/bind.hpp>

#include <algorithm>
#include <fstream>

#include "Fragmentation/Summation/Containers/FragmentationResultContainer.hpp"

static bool file_not_exists(const boost::filesystem::path &path) {
  return !boost::filesystem::exists(path);
}

int main(int argc, char **argv)
{
  if (argc < 2) {
    std::cout << "Usage:" << argv[0] << "<file 1> <file2>\n";
    return 255;
  }

  // parse two file names
  std::vector<boost::filesystem::path> filenames;
  filenames.reserve(2);
  filenames.push_back(std::string(argv[1]));
  filenames.push_back(std::string(argv[2]));

  // check whether both files exists
  std::vector<boost::filesystem::path>::iterator iter =
      std::find_if(
          filenames.begin(), filenames.end(),
          file_not_exists);
  if (iter != filenames.end()) {
    std::cerr << "The file " << iter->string() << " does not exist.\n";
    return 255;
  }

  FragmentationResultContainer &results = FragmentationResultContainer::getInstance();
  // deserialize and compare
  // Note that because FragmentationResultContainer is a singleton, we cannot
  // compare two distinct instances. Therefore, we deserialize and serialize
  // again both files in order to compare the strings on grounds of the same
  // serialization function (and library).
  std::stringstream outfile1;
  std::stringstream outfile2;
  results.clear();
  {
    std::ifstream infile(filenames[0].string().c_str());
    boost::archive::text_iarchive ia(infile);
    boost::archive::text_oarchive oa(outfile1);
    ia >> results;
    oa << results;
  }
  results.clear();
  {
    std::ifstream infile(filenames[1].string().c_str());
    boost::archive::text_iarchive ia(infile);
    boost::archive::text_oarchive oa(outfile2);
    ia >> results;
    oa << results;
  }

  // because container is a singleton, we can only copy the memory

  if (outfile1.str() != outfile2.str()) {
    std::cout << "The two containers differ:\n";
    std::cout << outfile1.str() << std::endl;
    std::cout << outfile2.str() << std::endl;
    return 5;
  }

  return 0;
}
