/*
 * Project: MoleCuilder
 * Description: creates and alters molecular systems
 * Copyright (C)  2010-2012 University of Bonn. All rights reserved.
 *
 *
 *   This file is part of MoleCuilder.
 *
 *    MoleCuilder is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    MoleCuilder is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with MoleCuilder.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * ShapeRegistryUnitTest.cpp
 *
 *  Created on: Sep 13, 2012
 *      Author: ankele
 */

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cppunit/CompilerOutputter.h>
#include <cppunit/extensions/TestFactoryRegistry.h>
#include <cppunit/ui/text/TestRunner.h>

#include <cmath>
#include <limits>

#ifdef HAVE_TESTRUNNER
#include "UnitTestMain.hpp"
#endif /*HAVE_TESTRUNNER*/

#include "CodePatterns/Assert.hpp"

#include "Helpers/defs.hpp"
#include "Shapes/BaseShapes.hpp"
#include "Shapes/BaseShapes_impl.hpp"
#include "Shapes/Shape_impl.hpp"
#include "Shapes/ShapeRegistry.hpp"

#include "ShapeRegistryUnitTest.hpp"

// Registers the fixture into the 'registry'
CPPUNIT_TEST_SUITE_REGISTRATION( ShapeRegistryTest );

void ShapeRegistryTest::setUp()
{
  // failing asserts should be thrown
  ASSERT_DO(Assert::Throw);

  ShapeRegistry::getInstance();

  Shape s = Sphere();
  s.setName("Sphere1");
  ShapeRegistry::getInstance().addShape(s);
  s = Cuboid();
  s.setName("Cube1");
  ShapeRegistry::getInstance().addShape(s);
  s = Sphere(Vector(1,0,0), 1);
  s.setName("Sphere2");
  ShapeRegistry::getInstance().addShape(s);
}

void ShapeRegistryTest::tearDown()
{
  ShapeRegistry::purgeInstance();
}

void ShapeRegistryTest::queryTest()
{
  CPPUNIT_ASSERT(ShapeRegistry::getInstance().isPresentByName("Sphere1"));
  CPPUNIT_ASSERT(ShapeRegistry::getInstance().isPresentByName("Sphere2"));
  CPPUNIT_ASSERT(ShapeRegistry::getInstance().isPresentByName("Cube1"));
  CPPUNIT_ASSERT(!ShapeRegistry::getInstance().isPresentByName("Sphere7"));
  CPPUNIT_ASSERT(!ShapeRegistry::getInstance().isPresentByName("sdfksdfhjkh"));
}

void ShapeRegistryTest::sphereTest()
{
  CPPUNIT_ASSERT(ShapeRegistry::getInstance().isPresentByName("Sphere2"));
  Shape *s = ShapeRegistry::getInstance().getByName("Sphere2");

  CPPUNIT_ASSERT( s->isInside( Vector(1.5,0.,0.) ) );
  CPPUNIT_ASSERT( s->isInside( Vector(1.,.5,0.) ) );
  CPPUNIT_ASSERT( s->isInside( Vector(1.,0.,.5) ) );
  CPPUNIT_ASSERT( s->isOnSurface( Vector(2.,0.,0.) ) );
  CPPUNIT_ASSERT( s->isOnSurface( Vector(1.,1.,0.) ) );
  CPPUNIT_ASSERT( s->isOnSurface( Vector(1.,0.,1.) ) );
  CPPUNIT_ASSERT( !s->isInside( Vector(-.5,0.,0.) ) );
  CPPUNIT_ASSERT( !s->isInside( Vector(0.,-.5,0.) ) );
  CPPUNIT_ASSERT( !s->isInside( Vector(0.,0.,-.5) ) );
}

