/*
 * ShutdownOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_
#define FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

#include "Controller/Commands/Operation.hpp"

class ShutdownOperation : public Operation  {
public:
  /// Constructor for class ShutdownOperation.
  ShutdownOperation(Connection &_connection, const std::string& _host, const std::string& _service) :
    Operation(_connection, _host, _service) {}
  /// Destructor for class ShutdownOperation
  ~ShutdownOperation() {}

public:
  // placing receive jobs operations into an io_service
  virtual void operator()();

  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Handle completion of a Shutdown operation.
  void handle_connect_shutdown(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// internal function to connect to server and receive calculated results
  void connect_shutdown();
};

#endif /* FRAGMENTCONTROLLER_SHUTDOWNOPERATION_HPP_ */
