/*
 * Operation.hpp
 *
 *  Created on: Nov 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_OPERATION_HPP_
#define FRAGMENTCONTROLLER_OPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>
#include <vector>

#include "Connection.hpp"

class Operation {
public:
  Operation(Connection &_connection, const std::string& _host, const std::string& _service);
  virtual ~Operation();
public:
  /// The Connection to the server.
  Connection &connection_;

  // virtual function pointer to the operation to do
  virtual void operator()() = 0;

  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator) = 0;

  void testfunction(const std::string& _host, const std::string& _service);

  /// Handle completion of an operation.
  void handle_FinishOperation(const boost::system::error_code& e);

  enum Exitflag_t {
    OkFlag = 0,
    ErrorFlag = 255
  };

  /** Getter for Exitflag.
   *
   * @return Exitflag
   */
  size_t getExitflag() const
  {
    return Exitflag;
  }

protected:
  /// internal function to resolve host name and ip address
  boost::asio::ip::tcp::resolver::iterator getEndpointIterator();

  /// internal function to disconnect from server
  void disconnect();

protected:
  /// host name of server
  const std::string host;

  // service to connect to to
  const std::string service;

  // exit flag of this operation
  enum Exitflag_t Exitflag;
};

#endif /* FRAGMENTCONTROLLER_OPERATION_HPP_ */
