/*
 * CheckResultsOperation.hpp
 *
 *  Created on: Dec 11, 2011
 *      Author: heber
 */

#ifndef FRAGMENTCONTROLLER_CHECKRESULTSOPERATION_HPP_
#define FRAGMENTCONTROLLER_CHECKRESULTSOPERATION_HPP_

// include config.h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <boost/asio.hpp>
#include <string>

#include "Connection.hpp"

#include "Controller/Commands/Operation.hpp"


class CheckResultsOperation : public Operation  {
public:
  /// Constructor for class CheckResultsOperation.
  CheckResultsOperation(Connection &_connection, const std::string& _host, const std::string& _service) :
    Operation(_connection, _host, _service),
    doneJobs(0)
  {}
  /// Destructor for class CheckResultsOperation
  ~CheckResultsOperation() {}

public:
  // placing receive jobs operations into an io_service
  virtual void operator()();

  // virtual function pointer to the connection handler
  virtual void handle_connect(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Handle completion of a CheckResults operation.
  void handle_connect_check(const boost::system::error_code& e,
      boost::asio::ip::tcp::resolver::iterator endpoint_iterator);

  /// Callback function when doneJobs have been received.
  void handle_ReceiveDoneJobs(const boost::system::error_code& e);

  /// internal function to connect to server and check done jobs
  void connect_check();

  /** Getter for doneJobs.
   *
   * \sa checkResults()
   * \param doneJobs
   */
  size_t getDoneJobs() const
  {
    return doneJobs;
  }

protected:
  /// currently calculated results
  size_t doneJobs;
};

#endif /* FRAGMENTCONTROLLER_CHECKRESULTSOPERATION_HPP_ */
